package com.elitesland.sale.api.vo.resp.crm;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


@Data
@ApiModel(value = "导出客户地址信息", description = "导出客户地址信息")
public class CustBankExportVO implements Serializable {

    private static final long serialVersionUID = -7484995015907932497L;
    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "客户编码")
    private String custCode;

    @ApiModelProperty(value = "客户号")
    private String custCode2;
    @ApiModelProperty("银行信息ID")
    private Long id;
    @ApiModelProperty("地址薄地址号")
    private Long addrNo;
    @ApiModelProperty("地址薄名称")
    private String addrName;
    @ApiModelProperty("地址薄类型:[UDC]ORG:ADDR_TYPE")
    @SysCode(sys = "yst-supp", mod = "ADDR_TYPE")
    private String addrType;
    private String addrTypeName;
    @ApiModelProperty("账号类型:[UDC]ORG:ADDR_BANKACC_TYPE")
    @SysCode(sys = "yst-supp", mod = "ADDR_BANKACC_TYPE")
    private String accType;
    private String accTypeName;
    @ApiModelProperty("收付款方式：[UDC]COM:PAY_METHOD")
    @SysCode(sys = "yst-supp", mod = "PAY_METHOD")
    private String payCollectMethod;
    private String payCollectMethodName;
    @ApiModelProperty("是否默认：1是，0否")
    private Boolean defaultFlag;

    @ApiModelProperty("是否默认：1是，0否")
    private String defaultFlagName;
    @ApiModelProperty("银行ID")
    private Long bankId;
    @ApiModelProperty("银行编号")
    private String bankCode;
    @ApiModelProperty("银行名称")
    private String bankName;
    @ApiModelProperty("网点名称")
    private String branchName;
    @ApiModelProperty("开户行账号")
    private String bankAcc;
    @ApiModelProperty("开户人姓名")
    private String holderName;
    @ApiModelProperty("币种")
    private String currCode;
    @ApiModelProperty("币种名称")
    private String currName;

    @ApiModelProperty("第三方虚拟用户ID")
    private String thirdpartyVirtualUserId;
    @ApiModelProperty("第三方虚拟帐户")
    private String thirdpartyVirtualAcc;


}
