package com.elitesland.sale.api.vo.resp.pro;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @author Shadow（li qun）
 * @since 2021-12-02 15:48
 */
@Data
public class SalContractExportVO implements Serializable {

	private static final long serialVersionUID = -6348875454140647869L;
	@ApiModelProperty("合同编号")
    private String contractNo;

    @ApiModelProperty("合同类型")
    @SysCode(sys = "yst-sale", mod = "CONTRACT_TYPE")
    private String contractType;
    private String contractTypeName;

    @ApiModelProperty("合同状态")
    @SysCode(sys = "yst-sale", mod = "CONTRACT_STATUS")
    private String contractStatus;
    private String contractStatusName;

    @ApiModelProperty("合同名称")
    private String contractName;

    @ApiModelProperty("合同版本")
    private Integer contractVersion;

    @ApiModelProperty("项目名称")
    private String projName;

    @ApiModelProperty(value = "签约日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate signDate;

    @ApiModelProperty(value = "开始日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate beginDate;

    @ApiModelProperty(value = "结束日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate endDate;

    @ApiModelProperty("合同总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("币种名称")
    private String currName;

    @ApiModelProperty("客户编号")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("客户联系人")
    private String custPic;

    @ApiModelProperty("客户联系人电话")
    private String custPicTel;

    @ApiModelProperty("客户地址")
    private String custAddress;

    @ApiModelProperty("质保金尾款")
    private BigDecimal endAmt;

    @ApiModelProperty("外部合同号")
    private String contractNo2;

    @ApiModelProperty("合同质保期 数字N年")
    private String guaranteePeriod;

    @ApiModelProperty("城市")
    private String contractCity;

    @ApiModelProperty("费用承担方")
    @SysCode(sys = "yst-sale", mod = "FREIGHT_ON")
    private String feeCarrier;
    private String feeCarrierName;

    @ApiModelProperty("交货时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate deliverDate;

    @ApiModelProperty("产品安装")
    @SysCode(sys = "yst-sale", mod = "INSTALL_TYPE")
    private String installFlag;
    private String installFlagName;

    @ApiModelProperty("交付详细地址")
    private String deliverAddress;

    @ApiModelProperty("是否需要项目验收")
    private Boolean projConfirmFlag;
    private String projConfirmFlagName;

    @ApiModelProperty("合同质保金")
    private BigDecimal guaranteeAmt;

    @ApiModelProperty("配送方式")
    @SysCode(sys = "yst-sale", mod = "SO_DELIVER_METHOD")
    private String deliverMethod;
    private String deliverMethodName;

    @ApiModelProperty("签约公司")
    private String seSignOu;
    private String seSignOuName;

    @ApiModelProperty("签约部门")
    private String seSignDept;
    private String seSignDeptName;

    @ApiModelProperty("区域")
    @SysCode(sys = "yst-supp", mod = "OU_REGION")
    private String seRegion;
    private String seRegionName;

    @ApiModelProperty("销售员")
    private String seSalesman;
    private String seSalesmanName;

    @ApiModelProperty("销售员电话")
    private String seSalesmanTel;

    @ApiModelProperty("签约公司地址")
    private String seAddress;

    @ApiModelProperty("丙方编码")
    private String thCode;

    @ApiModelProperty("丙方名称")
    private String thName;

    @ApiModelProperty("丙方联系人")
    private String thContact;

    @ApiModelProperty("丙方联系人电话")
    private String thContactTel;

    @ApiModelProperty("丙方地址")
    private String thAddress;


    // 明细

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品规格")
    private String itemSpec;

    @ApiModelProperty("客户商品编码")
    private String custItemCode;

    @ApiModelProperty("商品品牌")
    private String itemBrand;
    private String itemBrandName;

    @ApiModelProperty("是否供应商直发")
    private Boolean suppFlag;
    private String suppFlagName;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty(value = "计量单位 [UDC]COM:UOM")
    @SysCode(sys = "yst-supp",mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("未税价格")
    private BigDecimal netPrice;

    @ApiModelProperty("未税金额")
    private BigDecimal netAmt;

    @ApiModelProperty("含税价格")
    private BigDecimal price;

    @ApiModelProperty("含税金额")
    private BigDecimal amt;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("折扣率")
    private BigDecimal discRatio;

    @ApiModelProperty("折扣含税额")
    private BigDecimal discAmt;

    @ApiModelProperty("基础价格")
    private BigDecimal basePrice;

    @ApiModelProperty("备注")
    private String remark;

}
