package com.elitesland.sale.api.vo.resp.pri;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/5 3:15 下午
 */
@Data
public class PriCrossPriceRespInVO implements Serializable {

    private static final long serialVersionUID = 229015227277641624L;

    @ApiModelProperty(value = "商品ID")
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "原始价格计量单位")
    private String priceUom;

    @ApiModelProperty(value = "原始内部结算价")
    private BigDecimal originPrice;

    @ApiModelProperty(value = "计量单位")
    private String uom;

    @ApiModelProperty(value = "转换后的内部结算价")
    private BigDecimal price;

    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "针对明细的错误信息，未获取到销售价或计量单位转换率")
    private String errorMsg;

}
