package com.elitesland.sale.api.vo.resp.taskinfo;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.sale.api.vo.resp.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;


/**
 * @author : http://www.chiner.pre
 * @date : 2023-4-11
 * @desc : 执行记录模板
 */
@Data
@ApiModel(description = "执行记录模板")
public class ExectRecordTempRespVO extends BaseModelVO {

    @ApiModelProperty("模板编码")
    private String tempCode;

    @ApiModelProperty("模板名称")
    private String tempName;

    @ApiModelProperty("公司id")
    private String ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("状态")
    private String state;

    @ApiModelProperty("任务类型")
    @SysCode(sys = "yst-sale",mod = "SALESMAN_TASK_TYPE")
    private String taskType;
    private String taskTypeName;

    @ApiModelProperty("模板描述")
    private String tempDesc;

    @ApiModelProperty("执行模板明细集合")
    private List<ExectRecordTempDtlRespVO> tempDtlRespVOS;

    @ApiModelProperty("附件集合")
    private List<FileInfoRespVO> fileInfoRespVOS;

}