package com.elitesland.sale.api.vo.resp.pro;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021-06-09 13:57:24
 */
@ApiModel(description = "销售合同增加商品")
@Data
public class SalContractItemRespVO implements Serializable {

    private static final long serialVersionUID = 6441122332483425158L;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty(value = "商品简称")
    private String itemAbbr;

    @ApiModelProperty("商品规格")
    private String spec;

    @ApiModelProperty("商品品牌")
    private String brand;

    @ApiModelProperty(value = "品牌名称")
    private String brandName;

    @ApiModelProperty(value = "外部编号")
    private String outerCode;

    @ApiModelProperty(value = "条码")
    private String barCode;

    @ApiModelProperty(value = "商品类型")
    private String itemType;
    private String itemTypeName;

    @ApiModelProperty(value = "商品类型")
    private String itemType2;
    private String itemType2Name;

    @ApiModelProperty(value = "商品状态")
    private String itemStatus;
    private String itemStatusName;

    @ApiModelProperty("计量单位")
    private String uom;
    private String uomName;

    @ApiModelProperty(value = "定价计量单位")
    private String pricingUom;
    private String pricingUomName;

    @ApiModelProperty(value = "发运计量单位")
    private String shipUom;
    private String shipUomName;

    @ApiModelProperty(value = "默认采购单位")
    private String purcUom;
    private String purcUomName;

    @ApiModelProperty(value = "毛重")
    private BigDecimal grossWeight;

    @ApiModelProperty(value = "净重")
    private BigDecimal netWeight;

    @ApiModelProperty(value = "重量单位")
    private String weightUnit;
    private String weightUnitName;

    @ApiModelProperty(value = "体积")
    private BigDecimal volume;

    @ApiModelProperty(value = "体积单位")
    private String volumeUnit;
    private String volumeUnitName;

    @ApiModelProperty(value = "配货类型")
    private String allocType;
    private String allocTypeName;

    @ApiModelProperty(value = "供应商ID")
    private Long suppId;

    @ApiModelProperty(value = "供应商编号")
    private String suppCode;

    @ApiModelProperty(value = "供应商名称")
    private String suppName;

    @ApiModelProperty(value = "税码(进项)")
    private String taxCode;

    @ApiModelProperty(value = "税率(进项)，小于1的小数，保留8位，四舍五入")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "税率描述(进项)")
    private String taxRateDesc;

    @ApiModelProperty(value = "税码2(销项)")
    private String taxCode2;

    @ApiModelProperty(value = "税率2(销项)")
    private BigDecimal taxRate2;

    @ApiModelProperty(value = "税率2描述(销项)")
    private String taxRate2Desc;

    @ApiModelProperty(value = "关税税率")
    private BigDecimal taxRateTariff;

    @ApiModelProperty(value = "是否需要安装")
    private Boolean installFlag;

    @ApiModelProperty(value = "是否启用批次号")
    private Boolean lotFlag;

    @ApiModelProperty(value = "效期管理标识")
    private Boolean guaranteeFlag;

    @ApiModelProperty(value = "保质期时长")
    private Integer guaranteePeriod;

    @ApiModelProperty(value = "保质期单位")
    private String guaranteePeriodUnit;
    private String guaranteePeriodUnitName;

    @ApiModelProperty(value = "保质期天数")
    private Integer guaranteeDays;

    @ApiModelProperty("基础价格")
    private BigDecimal basePrice;

}
