package com.elitesland.sale.service;

import com.elitesland.sale.Application;
import com.elitesland.sale.dto.SalContractDQtyRespDTO;
import com.elitesland.sale.dto.SalContractDRespDTO;
import com.elitesland.sale.dto.SalContractRespDTO;
import com.elitescloud.cloudt.common.base.ApiResult;
import feign.Param;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

import java.util.List;

/**
 *  销售合同请使用 saleContractRpcService
 * @author Shadow
 * @since 2021-08-06 14:46
 */
@FeignClient(name = Application.NAME, path = SalContractRpcService.URI)
public interface SalContractRpcService {
    String URI = Application.URI_PREFIX + "/contract";
	@GetMapping("/SalContractRpc/updateContractD")
    ApiResult<SalContractDRespDTO> updateContractD(@Param("did") Long did);

	@PostMapping("/SalContractRpc/queryContractDQty")
    ApiResult<List<SalContractDQtyRespDTO>> queryContractDQty(List<Long> relateDocDids);

	@PostMapping("/SalContractRpc/queryContractByCode")
    ApiResult<List<SalContractRespDTO>> queryContractByCode(List<String> contractNo);

}