package com.elitesland.sale.api.service.shop;

import com.elitesland.sale.api.vo.param.shop.BipFeedBackParam;
import com.elitesland.sale.api.vo.param.shop.BipFeedBackQueryParamVO;
import com.elitesland.sale.api.vo.resp.shop.BipFeedBackRespVO;
import com.elitesland.sale.api.vo.resp.shop.BipFeedBackSaveVO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * @author Joker (Xing Shixiang)
 * @create 2021-08-11 13:14
 */
public interface BipFeedBackService {
    /**
     * 添加一条意见
     * @param param param
     * @return id
     */
    Long addFeedBack(BipFeedBackParam param);

    /**
     * 获得该用户的意见
     * @return 该用户的意见
     */
    List<BipFeedBackRespVO> getFeedBackAllById();

    /**
     * 分页查询B端 客户反馈意见
     * @param searchParam 搜索参数
     * @return
     */
    PagingVO<BipFeedBackRespVO> query(BipFeedBackQueryParamVO searchParam);

    /**
     * 根据ID获取详情
     * @param id 主键id
     * @return 该用户的意见
     */
    BipFeedBackRespVO findOneById(Long id);

    /**
     * 回复意见反馈
     * @param saveVO 回复对象
     */
    void reply(BipFeedBackSaveVO saveVO);
}
