package com.elitesland.sale.api.vo.resp.pri;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/8/22 11:11
 */
@ApiModel(description = "价格导出参数")
@Data
public class PriSalePriceExportVO implements Serializable {
    private static final long serialVersionUID = -655506268785818018L;

    @ApiModelProperty(value = "商品编号")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "商品条码")
    private String barcode;

    @ApiModelProperty(value = "商品规格/型号")
    private String itemSpec;

    @ApiModelProperty(value = "商品品类编码")
    private String itemCateCode;

    @ApiModelProperty(value = "商品单位")
    private String uomName;

    @ApiModelProperty(value = "市场价")
    private BigDecimal marketPrice;

    @ApiModelProperty(value = "含税价格")
    private BigDecimal price;

    @ApiModelProperty(value = "指导价")
    private BigDecimal guidePrice;

    @ApiModelProperty(value = "活动价生效日期")
    private String promDateFLD;
    private LocalDate promDateF;

    @ApiModelProperty(value = "活动价失效日期")
    private String promDateTLD;
    private LocalDate promDateT;

    @ApiModelProperty("活动含税价格")
    private BigDecimal promotionPrice;

    @ApiModelProperty("活动不含税价格")
    private BigDecimal promotionNetPrice;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "客户编码")
    private String custCode;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "客户等级")
    @SysCode(sys = "yst-sale", mod = "CUST_LEVEL")
    private String custLevel;
    private String custLevelName;

    @ApiModelProperty(value = "销售区域")
    @SysCode(sys = "yst-supp", mod = "OU_REGION")
    private String saleRegion;
    private String saleRegionName;

    @ApiModelProperty(value = "税率编号描述")
    private String taxRateDesc;

    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "货币码")
    private String currCode;

    @ApiModelProperty(value = "币种名称")
    private String currName;

    @ApiModelProperty(value = "生效时间")
    private String validFromLD;
    private LocalDate validFrom;

    @ApiModelProperty(value = "失效时间")
    private String validToLD;
    private LocalDate validTo;

    @ApiModelProperty(value = "价格状态")
    private String priceStatusName;

    @ApiModelProperty(value = "价格类型 [UDC]PRI:SALE_PRICE_TYPE")
    @SysCode(sys = "PRI", mod = "SALE_PRICE_TYPE")
    private String priceType;
    private String priceTypeName;

    @ApiModelProperty(value = "创建人")
    private String creator;

    @ApiModelProperty(value = "创建时间")
    private String createTimeLD;
    private LocalDate createTime;

    @ApiModelProperty(value = "更新人")
    private String updater;

    @ApiModelProperty(value = "更新时间")
    private String modifyTimeLD;
    private LocalDate modifyTime;
}
