package com.elitesland.sale.api.vo.resp.sal;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @auther JinXK
 * @date 2021/10/7 18:33
 */
@Data
@ApiModel(description = "销售开票申请参数(通用)")
public class SalInvSerialVO implements Serializable {

    @ApiModelProperty(value = "发票明细ID")
    private Long id;

    @ApiModelProperty(value = "开票申请ID")
    private Long masId;

    @ApiModelProperty(value = "开票系统流水号")
    private String invSerialNo;

    @ApiModelProperty(value = "发票号码")
    private String invNo;

    @ApiModelProperty(value = "发票代码")
    private String invCode;

    @ApiModelProperty(value = "发票校验码")
    private String invCheckCode;

    @ApiModelProperty("发票状态")
    @SysCode(sys = "FIN", mod = "INV_STATE")
    String invState;
    String invStateName;

    @ApiModelProperty(value = "开票日期")
    private LocalDateTime invDate;

    @ApiModelProperty(value = "电子发票PDF地址")
    private String ePdfUrl;

    @ApiModelProperty(value = "发票图片地址")
    private String ouCode;

    @ApiModelProperty(value = "纸质发票PDF地址")
    private String paperPdfUrl;
}
