package com.elitesland.sale.api.vo.save.exter;

import com.elitescloud.boot.model.entity.BaseModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/10/8 09:36
 */
@Data
@ApiModel(description = "潜在客户保存")
public class CrmScustSaveDTO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -529489408490941045L;

    @ApiModelProperty(value = "客户编码")
    private String custCode;

//    @ApiModelProperty(value = "外部系统客户编码")
//    private String custCode2;

    @ApiModelProperty(value = "税务登记号")
    private String taxRegNo;

    @ApiModelProperty(value = "客户名称", required = true)
    private String custName;

    @ApiModelProperty(value = "客户简称")
    private String custAbbr;

    @ApiModelProperty(value = "地址号")
    private Long addrNo;

    @ApiModelProperty(value = "英文名称")
    private String custName2;

    @ApiModelProperty(value = "公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "公司编号", required = true)
    private String ouCode;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "销售组织id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty(value = "销售组织编号")
    private String buCode;

    @ApiModelProperty(value = "销售组织名称")
    private String buName;

    @ApiModelProperty(value = "区域", required = true)
    private String region;

    @ApiModelProperty(value = "客户管理专员", required = true)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long agentEmpId;
    private String agentEmpCode;

    @ApiModelProperty(value = "客户分类", required = true)
    private String custType;

    @ApiModelProperty(value = "意向登级")
    private String intentLevel;

    @ApiModelProperty(value = "最近跟进日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDateTime lastFollowupDate;

    @ApiModelProperty(value = "客户行业")
    private String custIndustry;

    @ApiModelProperty(value = "客户来源")
    private String custSource;

    @ApiModelProperty(value = "客户规模")
    private String compScale;

    @ApiModelProperty(value = "客户联系人")
    private String contPerson;

    @ApiModelProperty(value = "客户联系人电话")
    private String mobile;

    @ApiModelProperty(value = "客户联系人邮箱")
    private String email;

    @ApiModelProperty(value = "客户年营业额")
    private String compTurnover;

    @ApiModelProperty(value = "是否是燃气用户 0:是 | 1:否")
    private String ifGasUser;

    @ApiModelProperty(value = "客户详情")
    private String custDetail;
}
