package com.elitesland.sale.api.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.sale.api.vo.param.taskinfo.SaleStatisticsStoreQueryVO;
import com.elitesland.sale.api.vo.resp.taskinfo.SaleStatisticsStoreRespVO;
import com.elitesland.sale.api.vo.resp.taskinfo.SaleStatisticsTeamRespVO;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * ClassName: SaleStatisticsService
 * Description:
 *
 * @author wz
 * @date 2023/5/22 18:03
 */
public interface SaleStatisticsService {

    PagingVO<SaleStatisticsStoreRespVO> pcPage(SaleStatisticsStoreQueryVO paramVO);
    PagingVO<SaleStatisticsStoreRespVO> appPage(SaleStatisticsStoreQueryVO paramVO);

    boolean statisticsSync(LocalDate dateTime);

    PagingVO<SaleStatisticsStoreRespVO> export(SaleStatisticsStoreQueryVO saleStatisticsStoreQueryVO);

    List<SaleStatisticsStoreRespVO> detail(SaleStatisticsStoreQueryVO paramVO);

    BigDecimal querySum(SaleStatisticsStoreQueryVO paramVO);

    List<String> storeQuery(SaleStatisticsStoreQueryVO paramVO);

    BigDecimal appQerySum(SaleStatisticsStoreQueryVO paramVO);

    List<SaleStatisticsTeamRespVO> queryByCodes(List<String> codeList);
}
