package com.elitesland.sale.api.vo.param.com;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/09/09
 */
@ApiModel(description = "短信验证码")
@Data
public class SmsVerifyCodeParamVO implements Serializable {
    private static final long serialVersionUID = 9137166807837632892L;

    @ApiModelProperty(value = "手机号", required = true, position = 1)
    @NotBlank(message = "手机号不能为空")
    private String mobile;

    @ApiModelProperty(value = "验证码有效期（秒为单位，默认60）", position = 2)
    private Long period;

    @ApiModelProperty(value = "验证码长度（默认4）", position = 3)
    private Integer codeLength;
}
