package com.elitesland.sale.api.vo.param.crm;

import com.elitescloud.boot.core.support.customfield.common.AbstractCustomFieldQueryParam;
import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * .
 *
 * @author Evin.dong
 * @date 2021-05-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "客户表查询入参")
public class CrmCustQueryParamVO extends AbstractCustomFieldQueryParam {

    private static final long serialVersionUID = 890948467039211262L;
    
    @ApiModelProperty("客户定义")
    private String custDef;

    @ApiModelProperty(value = "客户ids")
    private List<Long> ids;

    @ApiModelProperty(value = "客户编码")
    private String custCode;
    private List<String> custCodes;

    @ApiModelProperty(value = "userName")
    private String userName;

    @ApiModelProperty(value = "客户状态")
    private String custStatus;

    @ApiModelProperty(value = "客户等级")
    private String custLevel;

    @ApiModelProperty(value = "统一社会信用代码")
    private String certNo;

    @ApiModelProperty(value = "客户分类")
    private String custType;

    @ApiModelProperty(value = "客户归类")
    private String custType2;

    @ApiModelProperty(value = "税务登记号")
    private String taxRegNo;

    @ApiModelProperty(value = "地址号集合")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> addrNos;

    @ApiModelProperty(value = "业务员员工ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long agentEmpId;

    @ApiModelProperty(value = "项目公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "销售组织")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "外部系统用户")
    private String custCode2;

    @ApiModelProperty(value = "客户简称")
    private String custAbbr;

    @ApiModelProperty(value = "客户联系人")
    private String contPerson;

    @ApiModelProperty(value = "数据同步状态")
    private String intfStatus;

    @ApiModelProperty(value = "联系人电话")
    private String contPersonMobile;

    @ApiModelProperty(value = "是否是内部用户 true: 是, false: 否")
    private Boolean innerFlag;

    @ApiModelProperty(value = "是否翻译数据 true: 翻译, false: 不翻译")
    private Boolean transFlag;

//    @ApiModelProperty(value = "参保信息")
//    private String insured;

    @ApiModelProperty(value = "大B/小B")
    private String custGroup2;

    //lm

    @ApiModelProperty(value = "客户编码、客户号、客户名称")
    private String cust;

    @ApiModelProperty(value = "客户编码、客户号、客户名称、客户简称")
    private String custParam;

    @ApiModelProperty(value = "外部系统编码")
    private String outerCode;

    @ApiModelProperty("客户组  UDC，开票客户、地址客户、其他")
    private String custGroup;

    @ApiModelProperty(value = "是否全匹配custCode2  true全匹配 false模糊查询")
    private Boolean isFullMatchCustCode2;

    @ApiModelProperty(value = "区域")
    private String region;

    @ApiModelProperty(value = "父项客户号 展示cust_code字段对应的值，支持模糊查询")
    private String pid;
    
    @ApiModelProperty(value = "子客户所属主客户列表")
    private List<String> pids;

    @ApiModelProperty(value = "联系人")
    private String contactName;

    @ApiModelProperty(value = "联系电话")
    private String contactPhone;

    @ApiModelProperty(value = "客户类型")
    List<String> custTypes;

    @ApiModelProperty(value = "是否查询下级")
    private Boolean isSearchPid;

    @ApiModelProperty(value = "是否向立马订货 ‘0’:否 ’1‘：是")
    private String orderSignx;

    @ApiModelProperty(value = "全匹配 客户编码")
    private String fullMatchCustCode;

    @ApiModelProperty(value = "全匹配 客户名称")
    private String fullMatchCustName;

    @ApiModelProperty(value = "全匹配 客户简称")
    private String fullMatchCustAbbr;

    @ApiModelProperty(value = "全匹配 客户号")
    private String fullMatchCustCode2;

    @ApiModelProperty(value = "模糊匹配 客户号")
    private String contianCustCode2;

    @ApiModelProperty(value = "法人代表")
    private String repr;
    
    @ApiModelProperty(value = "法人手机号")
    private String reprCertMobile;
    
    @ApiModelProperty(value = "供应商模式（销售模式）")
    private String saleMode;

    @ApiModelProperty(value = "同步状态")
    private String syncStatus;
}
