package com.elitesland.sale.api.vo.param.itm;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitesland.sale.constant.OnShelfItemSortMethodEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel(description = "上架商品查询参数")
public class OnShelfItemQueryParam extends AbstractOrderQueryParam {
    private static final long serialVersionUID = -804138419580095330L;

    @ApiModelProperty("spuId集合")
    private List<Long> spuIds;

    @ApiModelProperty("skuId集合")
    private List<Long> skuIds;

    @ApiModelProperty("商品类型，整车、配件、广宣品、附件包")
    private String itemType2;

    @ApiModelProperty("商品名称，模糊搜索")
    private String itemName;

    @ApiModelProperty(value = "关键字类型，如果keyword不为空则keywordType不能为空")
    private String keywordType;

    @ApiModelProperty("关键字")
    private String keyword;

    @ApiModelProperty("属性参数列表")
    private List<AttrParam> attrList;

    @ApiModelProperty("排序方法，如果为空按默认排序方法排序")
    private OnShelfItemSortMethodEnum sortMethod;
}
