package com.elitesland.sale.api.vo.param.shop;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class DiscountGiftCustRespVO implements Serializable {

    private static final long serialVersionUID = 4538348001204817192L;
    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("客户ID")
    private Long custId;
    @ApiModelProperty("客户编码")
    private String custCode;
    private String custName;

    @ApiModelProperty(value = "门店编号")
    private String storeCode;

    @ApiModelProperty(value = "门店名称")
    private String storeName;

    @ApiModelProperty("经营性质")
    @SysCode(sys = "yst-supp", mod = "STORE_TYPE2")
    private String storeType2;
    private String storeType2Name;



    @ApiModelProperty("渠道 yst-supp:SALE_CHANNEL")
    private String saleChannel;
    private String saleChannelName;


    @ApiModelProperty("满赠主表id")
    private Long discountId;

    @ApiModelProperty("满赠主表code")
    private String discountCode;

    @ApiModelProperty("状态")
    private String status;
    private String statusName;

    private String creator;

    private LocalDateTime createTime;

}
