package com.elitesland.sale.api.vo.save;

import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class CrmSubCustImportVO  implements Serializable {
    @ApiModelProperty("客户归类")
    private final String custType2Name = "集团外客户";
    private String custType2;
    
    private final String custDefName = "子客户";
    private String custDef;
    
    @ApiModelProperty(value = "子客户编码")
    @ExcelProperty(index = 0)
    private String custCode;
    
    @ApiModelProperty(value = "子客户名称")
    @ExcelProperty(index = 1)
    private String custName;
    
    @ApiModelProperty(value = "客户简称")
    @ExcelProperty(index = 2)
    private String custAbbr;
    
    @ApiModelProperty("供应商模式名称")
    @ExcelProperty(index = 3)
    private String saleModeName;
    private String saleMode;
    
    @ApiModelProperty("父客户编码")
    @ExcelProperty(index = 4)
    private String pid;
    
    @ApiModelProperty("渠道 yst-supp:SALE_CHANNEL")
    @ExcelProperty(index = 5)
    private String saleChannelName;
    private String saleChannel;
    
    @ApiModelProperty("合同开始日期")
    @ExcelProperty(index = 6)
    private String es1;
    
    @ApiModelProperty("合同结束日期")
    @ExcelProperty(index = 7)
    private String es2;
    
    @ApiModelProperty("客户联系人")
    @ExcelProperty(index = 8)
    private String contactName;
    
    @ApiModelProperty("客户联系电话")
    @ExcelProperty(index = 9)
    private String contactPhone;
    
    @ApiModelProperty(value = "客户类型")
    @ExcelProperty(index = 10)
    private String custTypeName;
    private String custType;
    
    @ApiModelProperty(value = "公司编号")
    @ExcelProperty(index = 11)
    private String ouCode;
    private Long ouId;
    private String ouName;
    
    @ApiModelProperty(value = "销售组织")
    @ExcelProperty(index = 12)
    private String buCode;
    private Long buId;
    private String buName;
    
    @ApiModelProperty(value = "业务员编码")
    @ExcelProperty(index = 13)
    private String agentEmpCode;
    private Long agentEmpId;
  
    @ApiModelProperty(value = "默认允发期编码")
    @ExcelProperty(index = 14)
    private String allowShipRuleCode;
    
    @ApiModelProperty("允发最大批次数量")
    @ExcelProperty(index = 15)
    private String allowBatchMaxName;
    private String allowBatchMax;
    
    @ApiModelProperty("默认配送方式 yst-order:SO_DELIVER_METHOD")
    @ExcelProperty(index = 16)
    private String deliverMethodName;
    private String deliverMethod;
    
    @ApiModelProperty("承运信息")
    @ExcelProperty(index = 17)
    private String carrier;
    
    @ApiModelProperty(value = "付款条款 yst-supp:PAYMENT_TERM")
    @ExcelProperty(index = 18)
    private String paymentTermName;
    private String paymentTerm;
    
    @ApiModelProperty(value = "地址类型名称")
    @ExcelProperty(index = 19)
    private String addressTypeName;
    
    @ApiModelProperty(value = "是否默认")
    @ExcelProperty(index = 20)
    private String defaultFlagName;
    private Boolean defaultFlag;
    
    @ApiModelProperty(value = "联系人")
    @ExcelProperty(index = 21)
    private String contPerson;
    
    @ApiModelProperty(value = "联系人手机")
    @ExcelProperty(index = 22)
    private String contMobile;
    
    @ApiModelProperty(value = "联系人邮箱")
    @ExcelProperty(index = 23)
    private String email;
    
    @ApiModelProperty(value = "国家")
    @ExcelProperty(index = 24)
    private String countryName;
    
    @ApiModelProperty(value = "省")
    @ExcelProperty(index = 25)
    private String provinceName;
    
    @ApiModelProperty(value = "市")
    @ExcelProperty(index = 26)
    private String cityName;
    
    @ApiModelProperty(value = "区/县")
    @ExcelProperty(index = 27)
    private String countyName;
    
    @ApiModelProperty(value = "乡镇/街道")
    @ExcelProperty(index = 28)
    private String street;
    
    @ApiModelProperty(value = "详细地址")
    @ExcelProperty(index = 29)
    private String detailaddr;
    
    @ApiModelProperty("邮政编码")
    @ExcelProperty(index = 30)
    private String zipCode;
    
    @ApiModelProperty("交货清单")
    @ExcelProperty(index = 31)
    private String deliveryNote;
    
    @ApiModelProperty("使用要求")
    @ExcelProperty(index = 32)
    private String useDemand;
}