package com.elitesland.sale.dto.query;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 请求参数 - 内部结算价查询参数
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/1 2:07 下午
 */
@Data
public class PriCrossPriceReqDTO implements Serializable {

    private static final long serialVersionUID = 248246885360178612L;

    /**
     * 销售公司ID，对应采购单的供应商
     */
    @NotNull(message = "公司ID不得为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    /**
     * 客户ID，对应采购单的分子公司
     */
    @NotNull(message = "客户ID不得为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    /**
     * 区域
     */
    @NotNull(message = "销售区域不得为空")
    private String region;

    /**
     * 货币码
     */
    @NotBlank(message = "货币码不得为空")
    private String currCode;

    /**
     * 待查询价格的商品集合
     */
    @NotEmpty(message = "商品集合不得为空")
    @Valid
    private List<PriSaleItemReqDTO> items;

}
