package com.elitesland.sale.api.vo.resp.crm;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.convert.BooleanToIntegerConverter;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Convert;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * .
 *
 * @author evin.dong
 * @date 2021-05-24
 */
@ApiModel(description = "客户信息详情")
@Data
public class CrmCustDetailRespVO extends CustomFieldBaseModelVo implements Serializable {
    private static final long serialVersionUID = -2792666409261920365L;

    
    @ApiModelProperty("客户定义")
    private String custDef;
    
    @ApiModelProperty("销售模式")
    private String saleMode;
    
    @ApiModelProperty("法人代表")
    private String repr;
    
    @ApiModelProperty("法人联系方式")
    private String reprCertMobile;
    
    @ApiModelProperty("合同起始日期")
    private String es1;
    
    @ApiModelProperty("合同结束日期")
    private String es2;

    @ApiModelProperty(value = "客户编码")
    private String custCode;

    @ApiModelProperty(value = "客户编码弹窗标识")
    private String custCodePopupName;

    @ApiModelProperty(value = "地址簿Id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrId;

    @ApiModelProperty(value = "地址号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrNo;

    @ApiModelProperty(value = "外部系统客户编码")
    private String custCode2;

    @ApiModelProperty(value = "税务登记号")
    private String taxRegNo;

    @ApiModelProperty(value = "工商登记号")
    private String icRegisterNo;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "客户简称")
    private String custAbbr;

    @ApiModelProperty(value = "英文名称")
    private String custName2;

    @ApiModelProperty(value = "公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    private String ouName;

    @ApiModelProperty(value = "销售组织id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    private String buName;

    @ApiModelProperty(value = "区域 [UDC]ORG:OU_REGION")
    @SysCode(sys = "yst-supp", mod = "REGION")
    private String region;
    private String regionName;

    @ApiModelProperty(value = "客户管理专员id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long agentEmpId;
    private String agentEmpName;

    private String agentEmpCode;

    @ApiModelProperty(value = "客户分类 [UDC]CRM:CUST_TYPE")
    @SysCode(sys = "yst-sale", mod = "CUST_TYPE")
    private String custType;
    private String custTypeName;

    @ApiModelProperty(value = "客户状态 [UDC]yst-sale:CUST_STATUS")
    @SysCode(sys = "yst-sale", mod = "CUST_STATUS")
    private String custStatus;
    private String custStatusName;

    @ApiModelProperty(value = "客户等级")
    private String custLevel;

    @ApiModelProperty(value = "客户行业")
    private String custIndustry;

    @ApiModelProperty(value = "客户来源")
    private String custSource;

    @ApiModelProperty(value = "客户规模 [UDC]CRM:CUST_SCALE")
    @SysCode(sys = "yst-sale", mod = "CUST_SCALE")
    private String compScale;
    private String compScaleName;


    @ApiModelProperty(value = "客户年营业额 [UDC]CRM:CUST_TURNOVER")
    @SysCode(sys = "yst-sale", mod = "CUST_TURNOVER")
    private String compTurnover;
    private String compTurnoverName;

    @ApiModelProperty(value = "客户归类 [UDC]CRM:CUST_TYPE2")
    @SysCode(sys = "yst-sale", mod = "CUST_TYPE2")
    private String custType2;
    private String custType2Name;

    @ApiModelProperty(value = "发票类型 [UDC]CRM:INV_TYPE")
    @SysCode(sys = "yst-sale", mod = "INV_TYPE")
    private String invType;
    private String invTypeName;

    @ApiModelProperty(value = "开票抬头")
    private String invTitle;

    @ApiModelProperty(value = "税号")
    private String taxerNo;

    @ApiModelProperty(value = "开票地址")
    private String invAddress;

    @ApiModelProperty(value = "开票电话")
    private String invTel;

    @ApiModelProperty(value = "开户银行")
    private String invBankName;

    @ApiModelProperty(value = "银行账户")
    private String invBankAcc;

    @ApiModelProperty(value = "联系人")
    private String invPicName;

    @ApiModelProperty(value = "联系人电话")
    private String invPicPhone;

    @ApiModelProperty(value = "付款条款 yst-supp:PAYMENT_TERM")
    private String paymentTerm;
    private String paymentTermName;
    @ApiModelProperty(value = "父项客户号")
    @JsonSerialize(using = ToStringSerializer.class)
    private String pid;
    private String pidCode;
    private String pidName;

    @ApiModelProperty(value = "客户地址列表数据")
    private List<CrmCustAddrRespVO> addrList;

    @ApiModelProperty(value = "证照信息列表数据")
    private List<CrmCustQualifyRespVO> qualifyList;

    @ApiModelProperty(value = "银行信息")
    private List<OrgAddrBankAccRespVO> orgAddrBankAccList;

    @ApiModelProperty(value = "客户详情")
    private String custDesc;


    @ApiModelProperty("联系人电话")
    private String contactPhone;

    @ApiModelProperty("联系人姓名")
    private String contactName;

    @ApiModelProperty("币种")
    private String custCurr;

    @ApiModelProperty("币种")
    private String custCurrName;

    @ApiModelProperty("客户账户信息")
    private CustAccountVO custAccountVO;

    @ApiModelProperty("外部系统编码")
    private String outerCode;

    @ApiModelProperty("客户组  UDC，开票客户、地址客户、其他")
    private String custGroup;
    private String custGroupName;

    @ApiModelProperty(value = "统一社会信用代码")
    private String certNo;


    @ApiModelProperty(value = "纳税人类型")
    private String taxpayerType;


    @ApiModelProperty(value = "是否创建公司 0：否 1：是")
    private Integer isCreateOu;



    @ApiModelProperty(value = "客户等级")
    private String custLevelName;

//    @ApiModelProperty(value = "付款条款")
//    private String paymentTermName;


    @ApiModelProperty(value = "登录账号")
    private String userName;


    @ApiModelProperty("库存客户号 弹窗选择启用的客户信息，如果库存客户号为空时，客户看不到任务库存")
    private String invCustCode;

    @ApiModelProperty("向立马订货 是、否 从K3系统接口同步，用于标识某些二网客户能够直接向立马订货")
    private String orderSignx;

    @ApiModelProperty("自动生成调整单  从K3系统接口同步， 是、否 场景：客户订购配件时，配件账户没有账款，能够从整车账户扣款，打了该标识的客户可以自动生成调整单")
    private String adjustSignx;

    @ApiModelProperty("客户公司")
    List<CustBelongOuVO> belongOus;

    @ApiModelProperty(value = "纳税人类型")
    private String TaxpayerTypeName;

    @ApiModelProperty(value = "父项客户号")
    private String pid2;

    @ApiModelProperty(value = "父项客户号描述")
    private String pid2Abbr;

    @ApiModelProperty(value = "库存客户号")
    private String invCustCode2;


    @ApiModelProperty(value = "默认允发期code")
    private String allowShipRuleCode;


    @ApiModelProperty(value = "允发最大批次数量")
    @SysCode(sys = "yst-sale", mod = "ALLOW_SHIP_BATCH_MAX")
    private String allowBatchMax;
    private String allowBatchMaxName;

    @ApiModelProperty(value = "允发期规则")
    private AllowShipRuleRespVO allowShipRuleRespVO;

    @ApiModelProperty(value = "交货清单")
    private List<DeliveryListRespVO> deliveryList;


    @ApiModelProperty("渠道 yst-supp:SALE_CHANNEL")
    private String saleChannel;
    private String saleChannelName;
    @ApiModelProperty("默认配送方式 yst-order:SO_DELIVER_METHOD")
    private String deliverMethod;
    private String deliverMethodName;

    @ApiModelProperty("承运信息")
    private String carrier;

    private String cat;

    private String cat2;

    private String cat3;

    private String cat4;

    private String cat5;

    private String cat6;

    private String cat7;

    private String cat8;

    private String cat9;

    private String cat10;

    private String cat11;

    private String cat12;

    private String cat13;

    private String cat14;

    private String cat15;

    private String cat16;

    private String cat17;

    private String cat18;

    private String cat19;

    private String cat20;

    @ApiModelProperty("公司编号")
    private String ouCode;

    @ApiModelProperty(value = "税率编号")
    private String taxRateNo;

    @ApiModelProperty(value = "内外部客户")
    @SysCode(sys = "yst-sale", mod = "CUST_IN_OUT")
    private String inOutCust;
    private String inOutCustName;

    @ApiModelProperty("门店总数")
    private Integer storeCount;

    @ApiModelProperty("活跃门店数")
    private Integer activeStoreCount;

    @ApiModelProperty(value = "注册地址")
    private String registerAddress;
}
