package com.elitesland.sale.dto;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/1 7:14 下午
 */
@Data
public class PriSalePriceSimpleDTO implements Serializable {

    private static final long serialVersionUID = 3691354369719173426L;

    /**
     * 商品ID
     */
    private Long itemId;

    /**
     * 商品编码
     */
    private String itemCode;

    /**
     * 计量单位
     */
    private String uom;

    /**
     * 基础价格
     */
    private BigDecimal basePrice;

    /**
     * 销售价格
     */
    private BigDecimal salePrice;

    /**
     * 销售底价
     */
    private BigDecimal floorPrice;

    /**
     * 税率编码
     */
    private String taxRateNo;

    /**
     * 税率
     */
    private BigDecimal taxRate;

    /**
     * 错误信息，当未获取到销售价时，该字段不为空
     */
    private String errorMsg;

}
