/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.sale.api.vo.convert;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.elitescloud.boot.exception.BusinessException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringLocalDateTimeConverter
implements Converter<LocalDateTime> {
    private static final Logger log = LoggerFactory.getLogger(StringLocalDateTimeConverter.class);
    private static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    private static final String DATE_PATTERN_1 = "yyyy/MM/dd";
    private static final String DATE_PATTERN_2 = "yyyy-M-d";
    private static final String DATE_PATTERN_3 = "yyyy/M/d";
    private static final DateTimeFormatter defaultFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter formatter1 = DateTimeFormatter.ofPattern("yyyy/MM/dd");
    private static final DateTimeFormatter formatter2 = DateTimeFormatter.ofPattern("yyyy-M-d");
    private static final DateTimeFormatter formatter3 = DateTimeFormatter.ofPattern("yyyy/M/d");
    private static final List<DateTimeFormatter> formatters = new ArrayList<DateTimeFormatter>();

    public Class supportJavaTypeKey() {
        return null;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return null;
    }

    public LocalDateTime convertToJavaData(CellData cellData, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        String date = cellData.getStringValue();
        for (DateTimeFormatter formatter : formatters) {
            try {
                LocalDate localDate = LocalDate.parse(date, formatter);
                return LocalDateTime.of(localDate, LocalTime.of(0, 0));
            }
            catch (Exception e) {
                log.error("{} can't parse date.", (Object)formatter);
            }
        }
        throw new BusinessException(date + "\u4e0d\u662f\u53ef\u89e3\u6790\u7684\u65e5\u671f\u683c\u5f0f");
    }

    public CellData convertToExcelData(LocalDateTime localDateTime, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        return null;
    }

    static {
        formatters.add(defaultFormatter);
        formatters.add(formatter1);
        formatters.add(formatter2);
        formatters.add(formatter3);
    }
}

