package com.elitesland.sale.api.vo.resp.salesman;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.system.dto.resp.EmployeeUnderlingDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author Danny.Wang
 * @title EmployeeInfoRespVO
 * @Date2023/2/28 9:33
 */
@Data
@ApiModel("员工信息返回参数")
public class EmployeeInfoRespVO {
    @ApiModelProperty("员工ID")
    private Long id;

    @ApiModelProperty("员工编码")
    private String code;

    @ApiModelProperty("登录号")
    private String username;

    @ApiModelProperty("姓名")
    private String fullName;

    @ApiModelProperty("性别")
    private String gender;

    @ApiModelProperty("性别名称")
    private String genderName;

    @ApiModelProperty("是否启用")
    private Boolean enabled;

    @ApiModelProperty("电话")
    private String phone;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("组织信息")
    private List<IdCodeNameParam> orgList;

    @ApiModelProperty("组织名称")
    private List<String> orgNames;

    @ApiModelProperty("下属数量")
    private Integer underlingNum;

    @ApiModelProperty("下属")
    private List<EmployeeUnderlingDTO> underlingList;

    @ApiModelProperty("是否有下级员工")
    public Boolean getHasUnderling() {
        return underlingNum != null && underlingNum > 0;
    }

}
