package com.elitesland.sale.api.vo.resp.contract;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.sys.component.med.BaseModelVOMedItem;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class SaleContractItemRespVO extends BaseModelVOMedItem {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("记录唯一id")
    private Long id;
    @ApiModelProperty("主表ID")
    private Long masId;

    @ApiModelProperty("物料ID")
    private Long itemId;

    @ApiModelProperty("物料编码")
    private String itemCode;

    @ApiModelProperty("物料名称")
    private String itemName;

    @ApiModelProperty("物料规格")
    private String itemSpec;

    @ApiModelProperty("要求发货日期")
    private LocalDateTime shipDate;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("订购单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("基本单位数量")
    private BigDecimal baseQty;

    @ApiModelProperty("基本单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String baseUom;
    private String baseUomName;

    @ApiModelProperty("含税单价")
    private BigDecimal taxPrice;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("不含税价")
    private BigDecimal netPrice;

    @ApiModelProperty("币种")
    private String currCode;
    private String currName;

    @ApiModelProperty("含税金额")
    private BigDecimal amt;

    @ApiModelProperty("未税金额")
    private BigDecimal netAmt;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("备注")
    private String remark;


    @ApiModelProperty("渠道 yst-supp:SALE_CHANNEL")
    @SysCode(sys = "yst-supp", mod = "SALE_CHANNEL")
    private String saleChannel;
    private String saleChannelName;
    @ApiModelProperty("已执行数量")
    private BigDecimal executedQty;

    @ApiModelProperty("中包装单位")
    private String uom3;
    @ApiModelProperty("大包装单位")
    private String uom4;
    @ApiModelProperty("中包装单位转换系数")
    private BigDecimal uomRatio3;
    @ApiModelProperty("大包装单位转换系数")
    private BigDecimal uomRatio4;
    @ApiModelProperty("收款协议类型")
    private String protocolType;
    @ApiModelProperty("收款协议编码")
    private String protocolCode;
    @ApiModelProperty("收款协议名称")
    private String protocolName;
}
