package com.elitesland.sale.api.vo.param.itm;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel(description = "上架商品查询参数")
public class OnShelfItemAcrossQueryParam extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 1748718735572012616L;

    @ApiModelProperty("商品类型")
    private String itemType2;

    @ApiModelProperty("SPU编号")
    private String spuCode;

    @ApiModelProperty("SPU名称")
    private String spuName;

    @ApiModelProperty("排除的spuId")
    private List<Long> notInSpuIds;

    @ApiModelProperty("spuId集合")
    private List<Long> spuIds;
}
