package com.elitesland.sale.dto;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/1 7:14 下午
 */
@Data
public class PriCrossPriceSimpleDTO implements Serializable {

    /**
     * 商品ID
     */
    private Long itemId;

    /**
     * 商品编码
     */
    private String itemCode;

    /**
     * 商品名称
     */
    private String itemName;

    /**
     * 原始价格计量单位
     */
    private String priceUom;

    /**
     * 原始内部结算价
     */
    private BigDecimal originPrice;

    /**
     * 计量单位
     */
    private String uom;

    /**
     * 转换后的内部结算价
     */
    private BigDecimal price;

    /**
     * 税率
     */
    private BigDecimal taxRate;

    /**
     * 税率编号
     */
    private String taxRateNo;

    /**
     * 错误信息，当未获取到内部结算价时，该字段不为空
     */
    private String errorMsg;

}
