package com.elitesland.sale.api.vo.param.pro;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * 分页查询参数 - 合同验收分页查询
 * @author Eric.li (Li Jia Zhe)
 * @date 2021-06-21 10:13
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "合同验收分页查询请求参数")
public class SalAcceptancePagingParam extends AbstractOrderQueryParam implements Serializable {

    private static final long serialVersionUID = -2044866380115936219L;

    @ApiModelProperty(value = "验收单号")
    private String docNo;

    @ApiModelProperty(value = "公司")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "客户")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    @ApiModelProperty(value = "验收日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate acDate;

    @ApiModelProperty(value = "申请日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate applyDate;

    @ApiModelProperty(value = "合同编号")
    private String contractNo;

    @ApiModelProperty(value = "合同名称")
    private String contractName;

    @ApiModelProperty(value = "项目名称")
    private String projName;

    @ApiModelProperty("状态 [UDC] SAL:AC_STATUS")
    @SysCode(sys = "yst-sale",mod = "AC_STATUS")
    private String acStatus;
    private String acStatusName;

    @ApiModelProperty(value = "申请人")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long applyEmpId;

}
