package com.elitesland.sale.api.vo.resp.itm;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
@ApiModel("销售属性选择")
public class SaleAttrOptVO implements Serializable {
    private static final long serialVersionUID = 3218700846285538763L;

    @ApiModelProperty("属性code")
    private String code;
    @ApiModelProperty("属性名")
    private String name;
    @ApiModelProperty("所有sku该属性值的集合")
    private List<Value> values;

    @Data
    @ApiModel("属性值")
    public static class Value implements Serializable{
        @ApiModelProperty("属性值")
        private String value;
        @ApiModelProperty("是否选中")
        private boolean opted;
        @ApiModelProperty("该属性值是否可用")
        private boolean available;
    }
}
