package com.elitesland.sale.api.vo.resp.pro;

import com.elitesland.sale.api.vo.resp.com.ComSaleFileComVO;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 返回参数 - 销售合同
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/9 8:03 下午
 */
@ApiModel(description = "销售合同返回参数")
@Data
public class SalContractDetailRespVO implements Serializable {
    private static final long serialVersionUID = -4912524879118421191L;

    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("合同编号")
    private String contractNo;

    @ApiModelProperty("外部合同号")
    private String contractNo2;

    @ApiModelProperty("合同版本")
    private Integer contractVersion;

    @ApiModelProperty("合同名称")
    private String contractName;

    @ApiModelProperty("项目名称")
    private String projName;

    @ApiModelProperty("合同类型")
    @SysCode(sys = "yst-sale", mod = "CONTRACT_TYPE")
    private String contractType;
    private String contractTypeName;

    @ApiModelProperty("合同状态")
    private String contractStatus;

    @ApiModelProperty("合同质保期 数字N年")
    private String guaranteePeriod;

    @ApiModelProperty("城市")
    private String contractCity;

    @ApiModelProperty("费用承担方")
    @SysCode(sys = "yst-sale", mod = "FREIGHT_ON")
    private String feeCarrier;
    private String feeCarrierName;

    @ApiModelProperty("交货时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate deliverDate;

    @ApiModelProperty("产品安装")
    @SysCode(sys = "yst-sale", mod = "INSTALL_TYPE")
    private String installFlag;
    private String installFlagName;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("签约日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate signDate;

    @ApiModelProperty("开始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate beginDate;

    @ApiModelProperty("结束日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate endDate;

    @ApiModelProperty("合同总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("交付详细地址")
    private String deliverAddress;

    @ApiModelProperty("审批意见")
    private String apprComment;

    @ApiModelProperty("是否需要项目验收")
    private Boolean projConfirmFlag;

    @ApiModelProperty("合同质保金")
    private BigDecimal guaranteeAmt;

    @ApiModelProperty("配送方式")
    @SysCode(sys = "yst-sale", mod = "SO_DELIVER_METHOD")
    private String deliverMethod;
    private String deliverMethodName;

    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户编号")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("客户联系人")
    private String custPic;

    @ApiModelProperty("客户联系人电话")
    private String custPicTel;

    @ApiModelProperty("客户地址")
    private String custAddress;

    @ApiModelProperty("签约公司")
    private String bSignOu;
    private String bSignOuName;

    @ApiModelProperty("签约部门")
    private String bSignDept;
    private String bSignDeptName;

    @ApiModelProperty("区域")
    @SysCode(sys = "yst-supp", mod = "OU_REGION")
    private String bRegion;
    private String bRegionName;

    @ApiModelProperty("销售员")
    private String bSalesman;
    private String bSalesmanName;

    @ApiModelProperty("销售员电话")
    private String bSalesmanTel;

    @ApiModelProperty("签约公司地址")
    private String bAddress;

    @ApiModelProperty("丙方编码")
    private String cCode;

    @ApiModelProperty("丙方名称")
    private String cName;

    @ApiModelProperty("丙方联系人")
    private String cContact;

    @ApiModelProperty("丙方联系人电话")
    private String cContactTel;

    @ApiModelProperty("丙方地址")
    private String cAddress;

    @ApiModelProperty("来源单据类型")
    private String rootDocType;

    @ApiModelProperty("来源单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootDocId;

    @ApiModelProperty("来源单据编号")
    private String rootDocNo;

    @ApiModelProperty("来源单据类别 [UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp",mod = "DOC_CLS")
    private String rootDocCls;
    private String rootDocClsName;

    @ApiModelProperty("产品基本信息列表")
    private List<SalContractDDetailRespVO> itemDetails;

    @ApiModelProperty("收款计划")
    private List<SalContractRecvDetailRespVO> contractRecvs;

    @ApiModelProperty("附件列表")
    private List<ComSaleFileComVO> attachFiles;

    @ApiModelProperty("签约背景")
    private String signBackground;

    @ApiModelProperty("合同已收款金额")
    private BigDecimal receiptAmt;

    @ApiModelProperty("合同已开票金额")
    private BigDecimal applyAmt;

    @ApiModelProperty("质保金尾款")
    private BigDecimal endAmt;

}
