package com.elitesland.sale.api.vo.resp.pro;

import com.elitesland.sale.api.vo.resp.com.ComSaleFileComVO;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;

/**
 * 返回参数 - 项目信息
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/9 1:57 下午
 */
@ApiModel(description = "项目返回参数")
@Data
public class SalProjDetailRespVO implements Serializable {
    private static final long serialVersionUID = -7018071171415598938L;

    @ApiModelProperty("业务类型")
    private String busiType;

    @ApiModelProperty("渠道来源")
    private String channelType;

    @ApiModelProperty(value = "公司ID")
    private Long ouId;
    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    private String buName;

    @ApiModelProperty(value = "区域 [UDC]ORG:OU_REGION")
    @SysCode(sys = "yst-supp", mod = "OU_REGION")
    private String region;
    private String regionName;

    @ApiModelProperty("客户ID")
    private Long custId;
    @ApiModelProperty("客户编号")
    private String custCode;
    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("客户类型 [UDC]CRM:CUST_TYPE")
    @SysCode(sys = "yst-sale", mod = "CUST_TYPE")
    private String custType;
    private String custTypeName;

    @ApiModelProperty("客户来源 [UDC]CRM:CUST_SOURCE")
    @SysCode(sys = "yst-sale", mod = "CUST_SOURCE")
    private String custSource;
    private String custSourceName;

    @ApiModelProperty("客户地址")
    private String custAddress;

    @ApiModelProperty(value = "意向时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate intentTime;

    @ApiModelProperty("客户等级")
    private String custLevel;

    @ApiModelProperty("客户性质")
    private String custProp;

    @ApiModelProperty("财务属性")
    private String finProp;

    @ApiModelProperty("证件类型")
    private String idType;

    @ApiModelProperty("证件号码")
    private String idNo;

    @ApiModelProperty(value = "证件失效日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate idExpireDate;

    @ApiModelProperty("项目名称")
    private String projName;

    @ApiModelProperty("项目编号")
    private String projNo;

    @ApiModelProperty("CRM项目编号")
    private String projNo2;

    @ApiModelProperty("项目类型")
    @SysCode(sys = "yst-sale", mod = "PROJ_TYPE")
    private String projType;
    private String projTypeName;

    @ApiModelProperty("项目地址")
    private String projAddress;

    @ApiModelProperty("客户负责人")
    private String custPic;

    @ApiModelProperty("客户负责人电话")
    private String custPicTel;

    @ApiModelProperty(value = "报装户数")
    private Long installNum;

    @ApiModelProperty(value = "报装日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate installDate;

    @ApiModelProperty(value = "施工时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate constructTime;

    @ApiModelProperty("施工资质要求")
    private String constructRequire;

    @ApiModelProperty(value = "施工验收时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate constructConfirmTime;

    @ApiModelProperty("施工验收标准")
    private String constructConfirmStandard;

    @ApiModelProperty(value = "项目招标时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate projBidsTime;

    @ApiModelProperty(value = "项目安装时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate projInstallTime;

    @ApiModelProperty(value = "项目开盘时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate projOpenTime;

    @ApiModelProperty("项目付款方式")
    @SysCode(sys = "yst-sale", mod = "PROJ_PAYMENT_TYPE")
    private String projPayMethod;
    private String projPayMethodName;

    @ApiModelProperty(value = "通气时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate sameTime;

    @ApiModelProperty("客户类型(正式/潜在)")
    @SysCode(sys = "yst-sale",mod = "QT_TYPE")
    private String custType2;
    private String custType2Name;

    @ApiModelProperty(value = "附件列表")
    private List<ComSaleFileComVO> attachFiles;

}
