package com.elitesland.sale.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class CrmCustBaseDTO implements Serializable {
    private static final long serialVersionUID = 337453888835051834L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "客户ID")
    private Long id;

    @ApiModelProperty(value = "客户编码")
    private String custCode;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "客户简称")
    private String custAbbr;

    @ApiModelProperty(value = "内外部")
    private String inOutCust;

    @ApiModelProperty(value = "客户归类")
    private String custType2;
}
