package com.elitesland.sale.service;

import com.elitesland.sale.Application;
import com.elitesland.sale.dto.DemoDTO;
import com.elitesland.sale.dto.query.DemoReqDTO;
import com.elitescloud.cloudt.common.base.ApiResult;
import feign.Param;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 示例数据服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2021-05-10
 */
@FeignClient(name = Application.NAME, path = DemoRpcService.URI)
public interface DemoRpcService {

    String URI = Application.URI_PREFIX + "/demo";
    /**
     * 根据编码获取数据
     *
     * @param code 编码
     * @return 数据信息
     */
	@GetMapping("/demoRpc/getByCode")
    ApiResult<DemoDTO> getByCode(@Param("code") @NotBlank(message = "编码不能为空") String code);

    /**
     * 查询数据
     *
     * @param reqDTO 查询参数
     * @return 数据信息
     */
	@PostMapping("/demoRpc/query")
    ApiResult<List<DemoDTO>> query(DemoReqDTO reqDTO);
}
