package com.elitesland.sale.api.vo.param.sal;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/7/20 17:20
 */
@Data
@ApiModel(description = "销售报价单查询入参")
public class SalQuotationApproveParam implements Serializable {
    private static final long serialVersionUID = -2697495834423427267L;

    @ApiModelProperty("报价单id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("报价单单状态")
    private String docStatus;

    @ApiModelProperty("审批日期")
    private LocalDateTime apprTime;

    @ApiModelProperty("审批人")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long apprUserId;

    @ApiModelProperty("审批意见")
    private String apprComment;
}
