package com.elitesland.sale.api.vo.param.contract;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class SaleContractToSoParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    private Long id;
    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;


    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("签订地点")
    private String signPlace;
    @ApiModelProperty("合同模板")
    private String saleContractTemplate;
    @ApiModelProperty("合同来源")
    private String saleContractSource;
    @ApiModelProperty("合同金额")
    private BigDecimal amt;
    @ApiModelProperty("合同金额大写")
    private String amtUpper;
    @ApiModelProperty("结算方式")
    private String settleType;
    @ApiModelProperty("结算方式其他说明")
    private String settleTypeRemark;
    @ApiModelProperty("起效日期")
    private String agreementEffectiveDateType;
    @ApiModelProperty("账期天数")
    private Integer ardays;


    @ApiModelProperty("签订日期")
    private LocalDateTime docDate;

    @ApiModelProperty("生效日期")
    private LocalDateTime validFrom;

    @ApiModelProperty("失效日期")
    private LocalDateTime validTo;

    @ApiModelProperty("业务员ID")
    private Long agentEmpId;
    @ApiModelProperty("业务员编码")
    private String agentEmpCode;
    @ApiModelProperty("业务员名称")
    private String agentEmpName;


    @ApiModelProperty("发货要求1")
    private String deliverInstruct;
    @ApiModelProperty("发货要求2")
    private String deliverInstruc2;
    @ApiModelProperty("是否以归档  UDC:PUR:TRUE_OR_FALSE")
    private String archiveFlag;


    // 公司基本信息
    @ApiModelProperty(value = "公司基本信息-法人代表")
    private String ouReprName;
    @ApiModelProperty(value = "公司基本信息-纳税人识别号")
    private String ouCertNo;
    @ApiModelProperty(value = "公司基本信息-开户银行")
    private String ouBankName;
    @ApiModelProperty(value = "公司基本信息-支行")
    private String ouBranchName;
    @ApiModelProperty(value = "公司基本信息-银行账号")
    private String ouBankAcc;
    @ApiModelProperty(value = "公司基本信息-联系人")
    private String ouContact;
    @ApiModelProperty(value = "公司基本信息-联系电话")
    private String ouMobile;
    @ApiModelProperty(value = "公司基本信息-联系人邮箱")
    private String ouEmail;
    @ApiModelProperty(value = "公司基本信息-国家")
    private String ouCountry;
    @ApiModelProperty(value = "公司基本信息-省")
    private String ouProvince;
    @ApiModelProperty(value = "公司基本信息-市")
    private String ouCity;
    @ApiModelProperty(value = "公司基本信息-区")
    private String ouCounty;
    @ApiModelProperty(value = "公司基本信息-地址")
    private String ouAddress;

    @ApiModelProperty("公司基本信息-发货人姓名")
    private String ouShipContact;
    @ApiModelProperty("公司基本信息-发货人电话")
    private String ouShipMobile;
    @ApiModelProperty("公司基本信息-发货人邮箱")
    private String ouShipEmail;
    @ApiModelProperty(value = "公司基本信息-发货人国家")
    private String ouShipCountry;
    @ApiModelProperty(value = "公司基本信息-发货人省")
    private String ouShipProvince;
    @ApiModelProperty(value = "公司基本信息-发货人市")
    private String ouShipCity;
    @ApiModelProperty(value = "公司基本信息-发货人区")
    private String ouShipCounty;
    @ApiModelProperty(value = "公司基本信息-发货人地址")
    private String ouShipAddress;

    // 客户基本信息
    @ApiModelProperty(value = "供应商基本信息-法人代表")
    private String custReprName;
    @ApiModelProperty(value = "供应商基本信息-纳税人识别号")
    private String custCertNo;
    @ApiModelProperty(value = "供应商基本信息-开户银行")
    private String custBankName;
    @ApiModelProperty(value = "供应商基本信息-支行")
    private String custBranchName;
    @ApiModelProperty(value = "供应商基本信息-银行账号")
    private String custBankAcc;
    @ApiModelProperty(value = "供应商基本信息-联系人")
    private String custContact;
    @ApiModelProperty(value = "供应商基本信息-联系电话")
    private String custMobile;
    @ApiModelProperty(value = "供应商基本信息-联系人邮箱")
    private String custEmail;
    @ApiModelProperty(value = "供应商基本信息-国家")
    private String custCountry;
    @ApiModelProperty(value = "供应商基本信息-省")
    private String custProvince;
    @ApiModelProperty(value = "供应商基本信息-市")
    private String custCity;
    @ApiModelProperty(value = "供应商基本信息-区")
    private String custCounty;
    @ApiModelProperty(value = "供应商基本信息-地址")
    private String custAddress;

    @ApiModelProperty("供应商基本信息-收货人姓名")
    private String custRecvContact;
    @ApiModelProperty("供应商基本信息-收货人电话")
    private String custRecvMobile;
    @ApiModelProperty("供应商基本信息-收货人邮箱")
    private String custRecvEmail;
    @ApiModelProperty(value = "供应商基本信息-收货人国家")
    private String custRecvCountry;
    @ApiModelProperty(value = "供应商基本信息-收货人省")
    private String custRecvProvince;
    @ApiModelProperty(value = "供应商基本信息-收货人市")
    private String custRecvCity;
    @ApiModelProperty(value = "供应商基本信息-收货人区")
    private String custRecvCounty;
    @ApiModelProperty(value = "供应商基本信息-收货人地址")
    private String custRecvAddress;




    @ApiModelProperty(value = "付款方式")
    private String paymentMethod;
    @ApiModelProperty(value = "付款期限（天）")
    private Integer payTerm;
    @ApiModelProperty(value = "预付款比例（%）")
    private BigDecimal prepaymentRatio;
    @ApiModelProperty("开票期限")
    private Integer invoiceTerm;

    @ApiModelProperty("商品信息")
    private List<SaleContractItemToSoParam> itemSaveParamList;
}
