package com.elitesland.sale.api.vo.param.crm;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

@Data
@ApiModel(description = "允发期列表查询条件")
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AllowShipRuleParam implements Serializable {
    private static final long serialVersionUID = 8910624406847328402L;

    @ApiModelProperty(value = "编码")
    private String code;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "状态 UDC:yst-sale:ALLOW_SHIP_STATUS (ACTIVE:启用,CLOSED:禁用)")
    private String status;

    @ApiModelProperty(value = "编码集合")
    private List<String> codes;


}
