package com.elitesland.sale.api.vo.param.pro;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;

/**
 * 分页查询参数 - 销售收款计划分页查询
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/7 8:16 下午
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "销售收款计划分页查询请求参数")
public class SalContractRecvPagingParam extends AbstractOrderQueryParam implements Serializable {

    private static final long serialVersionUID = -8776527086229476568L;

    @ApiModelProperty(value = "合同编码")
    private String contractNo;

    @ApiModelProperty(value = "合同名称")
    private String contractName;

    // 合同名称反查出的合同ID集合
    private List<Long> contractIds;

    @ApiModelProperty(value = "客户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    @ApiModelProperty(value = "应收日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate arDate;

}
