package com.elitesland.sale.api.vo.resp.logistics;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel(description = "运费模板列表")
public class LogisticsTemplateDVO implements Serializable {

	private static final long serialVersionUID = 4494736144158559869L;
	@ApiModelProperty("id")
	private Long id;

    @ApiModelProperty("物流运费模板id")
    private Long templateId;

    @ApiModelProperty("行号")
    private Integer linNo;

    @ApiModelProperty("方式")
    @SysCode(sys = "yst-sale", mod = "TRANSPORT_TYPE")
    private String mode;
    private String modeName;


    @ApiModelProperty("市")
    private String cityName;

    @ApiModelProperty("市代码")
    private String cityCode;


//    @ApiModelProperty("区域")
//    private String area;

    @ApiModelProperty("默认件数")
    private Integer pieceNumber;

    @ApiModelProperty("默认运费")
    private BigDecimal defFreight;


    @ApiModelProperty("续件数")
    private Integer continuypieceNumber;

    @ApiModelProperty("增加运费")
    private BigDecimal addFreight;


}
