package com.elitesland.sale.api.vo.resp.sal;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.sale.api.vo.resp.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.Data;

@Data
@ApiModel(description = "卡券申领单展示")
public class SalMakeCardExportVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = 7971853965370958839L;

    @ApiModelProperty("单据编码")
    private String docNo;

    @ApiModelProperty("单据状态 [UDC]SAL:CARD_DOC_STATUS")
    @SysCode(sys = "yst-sale", mod = "CARD_DOC_STATUS")
    private String docStatus;

    @ApiModelProperty("单据状态 [UDC]SAL:CARD_DOC_STATUS")
    private String docStatusName;

    @ApiModelProperty("入库公司Id")
    @NotNull(message = "入库公司不可为空")
    private Long ouId;

    @ApiModelProperty("公司name")
    private String ouName;

    @ApiModelProperty("公司code")
    private String ouCode;

    @ApiModelProperty("仓库Id")
    @NotNull(message = "仓库不可为空")
    private Long whId;

    @ApiModelProperty("仓库code")
    private String whCode;

    @ApiModelProperty("仓库name")
    private String whName;

    @ApiModelProperty("来源")
    @SysCode(sys = "yst-sale", mod = "CARD_SOURCE")
    private String source;

    @ApiModelProperty("单据状态 [UDC]SAL:CARD_SOURCE")
    private String sourceName;

    @ApiModelProperty("商品种类类型")
    private Long itemTypeCount;

    @ApiModelProperty("卡数量")
    private Long cardCount;

    @ApiModelProperty("审核人")
    private Long approvedUserId;

    @ApiModelProperty("审核人")
    private String approvedUserName;

    @ApiModelProperty("审核时间")
    private LocalDateTime approvedTime;


    @ApiModelProperty("起始")
    private String startCardNo;

    @ApiModelProperty("商品name")
    private String endCardNo;

    @ApiModelProperty("商品name")
    private String itemName;

    @ApiModelProperty("商品code")
    private String itemCode;









}
