package com.elitesland.sale.api.vo.convert;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public class StringLocalDateTimeConverter implements Converter<LocalDateTime> {
    
    private static final String DEFAULT_PATTERN = "yyyy-MM-dd";
    @Override
    public Class supportJavaTypeKey() {
        return null;
    }
    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return null;
    }
    
    @Override
    public LocalDateTime convertToJavaData(CellData cellData, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(DEFAULT_PATTERN);
        LocalDate localDate = LocalDate.parse(cellData.getStringValue(),dateTimeFormatter);
        return LocalDateTime.of(localDate, LocalTime.of(0,0));
    }
    
    @Override
    public CellData convertToExcelData(LocalDateTime localDateTime, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        return null;
    }
    
}
