package com.elitesland.sale.api.vo.param.shop;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/24
 */
@Data
@ApiModel(description = "待上架商品查询参数")
public class BipItemToShelfQueryParamVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 2595916250313439719L;

    @ApiModelProperty(value = "上架编码", position = 1)
    private String shelfCode;

    @ApiModelProperty(value = "创建人ID", position = 2)
    private Long createUserId;

    @ApiModelProperty(value = "创建人名称", position = 11)
    private String creator;

    @ApiModelProperty(value = "所属公司ID", position = 3)
    private Long ouId;

    @ApiModelProperty(value = "状态，草稿、待审核、已拒绝、待上架", position = 4)
    private String state;

    @ApiModelProperty(value = "商品编码", position = 5)
    private String itemCode;

    @ApiModelProperty(value = "商品名称", position = 6)
    private String itemName;

    @ApiModelProperty(value = "一级商品分类ID", position = 7)
    private Long categoryId1;

    @ApiModelProperty(value = "二级商品分类ID", position = 8)
    private Long categoryId2;

    @ApiModelProperty(value = "三级商品分类ID", position = 9)
    private Long categoryId3;

    @ApiModelProperty(value = "运费收费方式 - 是否包邮", position = 10)
    private Boolean fareFree;
}
