package com.elitesland.sale.api.vo.resp.crm;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;

/**
 * @author Evin.dong
 * @version 1.0
 * @date 2021/5/24 9:24
 */
@Getter
@Setter
@ApiModel(description = "客户地址列表数据")
public class CrmCustAddrRespVO {

    @ApiModelProperty(value = "客户地址Id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "地址类型")
    private String addressType;
    private String addressTypeName;

    @ApiModelProperty(value = "地址id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrId;

    @ApiModelProperty(value = "默认")
    private Boolean defaultFlag;

    @ApiModelProperty(value = "联系人")
    private String contPerson;

    @ApiModelProperty(value = "联系人手机")
    private String contMobile;

    private String mobile;

    @ApiModelProperty(value = "联系人电话")
    private String contTel;

    @ApiModelProperty(value = "联系人传真")
    private String contFax;

    @ApiModelProperty(value = "联系人邮箱")
    private String contEmail;

    private String email;

    @ApiModelProperty(value = "国家")
    private String country;

    @ApiModelProperty(value = "国家")
    private String countryName;

    @ApiModelProperty(value = "省")
    private String province;
    private String provinceName;

    @ApiModelProperty(value = "市")
    private String city;
    private String cityName;

    @ApiModelProperty(value = "区/县")
    private String county;
    private String countyName;

    @ApiModelProperty(value = "乡镇/街道")
    private String street;

    @ApiModelProperty(value = "详细地址")
    private String detailaddr;

    @ApiModelProperty("记录创建者")
    private String creator;

    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("记录最后更新者")
    String updater;

    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty("二网直发")
    private String es1;

    @ApiModelProperty("邮政编码")
    private String zipCode;

//    @ApiModelProperty(value = "地址")
//    private String detailAddr;
}
