package com.elitesland.sale.api.vo.resp.salesman;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class SalesmansRespVO implements Serializable {
    private static final long serialVersionUID = -227033487314568382L;
    /**
     * 员工ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("业务员ID")
    private Long id;

    @ApiModelProperty("userId")
    private Long userId;

    private String userName;

    /**
     * 员工编号
     */
    @ApiModelProperty(value = "业务员编号")
//    private String empCode;
    private String salesmanNo;

    /**
     * 员工姓名
     */
    @ApiModelProperty(value = "业务员姓名")
//    private String empName;
    private String name;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("所属组织ID")
    private Long orgId;

    private String orgCode;
    /**
     * 所属组织名称
     */
    @ApiModelProperty(value = "所属组织名称")
    private String orgName;

    /**
     * 所属公司ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("所属公司ID")
    private Long ouId;

    /**
     * 所属公司名称
     */
    @ApiModelProperty(value = "所属公司名称")
    private String ouName;

    /**
     * 所属公司编号
     */
    @ApiModelProperty(value = "所属公司编号")
    private String ouCode;


    @ApiModelProperty(value = "登录账号")
    private String loginAccount;


    @ApiModelProperty(value = "业务员类型")
    private String salesmanType;
    private String salesmanTypeName;

    @ApiModelProperty(value = "手机号")
    private String phone;


    @ApiModelProperty("启用状态")
    private Integer enableStatus;
    private String enableStatusName;


    private String currCode;
    private String currName;


}
