package com.elitesland.sale.api.vo.param.sal;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Data;

@Data
@ApiModel(description = "卡券退还单搜索")
public class SalReturnCardParam extends AbstractExportQueryParam implements Serializable {
    private static final long serialVersionUID = 7971853965370958839L;

    @ApiModelProperty("id")
    private Long masId;

    @ApiModelProperty("单据编码")
    private String docNo;

    @ApiModelProperty("单据状态")
    private List<String> docStatus;

    @ApiModelProperty("绑定商品Id")
    private Long itemId;

    @ApiModelProperty("仓库Id")
    private Long whId;

    @ApiModelProperty("卡号")
    private String cardNo;

    @ApiModelProperty(value = "创建日期-start")
    private LocalDateTime createDateStart;

    @ApiModelProperty(value = "创建日期-end")
    private LocalDateTime createDateEnd;

    @ApiModelProperty(value = "审核人")
    private Long approvedUserId;

    @ApiModelProperty(value = "创建人")
    private Long createUserId;

    @ApiModelProperty(value = "审核日期-start")
    private LocalDateTime approvedDateStart;

    @ApiModelProperty(value = "审核日期-end")
    private LocalDateTime approvedDateEnd;




}
