package com.elitesland.sale.api.vo.resp.sal;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.sale.api.vo.resp.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.validation.constraints.NotNull;
import lombok.Data;
import org.hibernate.annotations.Comment;

@Data
@ApiModel(description = "卡券申领单展示")
public class SalMakeCardLineRespVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = 7971853965370958839L;

    @NotNull(message = "起始SN不可为空")
    private Long startCardNo;

    @NotNull(message = "结束SN不可为空")
    private Long endCardNo;

    @ApiModelProperty("商品公司Id")
    private Long itemId;

    @ApiModelProperty("商品name")
    private String itemName;

    @ApiModelProperty("商品code")
    private String itemCode;

    @ApiModelProperty("商品tyoe")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE")
    @NotNull(message = "商品类型必传")
    private String itemType;

    @ApiModelProperty("商品tyoe")
    private String itemTypeName;

    @ApiModelProperty("卡数量")
    private Long cardCount;

    @ApiModelProperty("批次")
    private String batch;

    @ApiModelProperty("卡类型")
    private String type;


    @ApiModelProperty("面值")
    private BigDecimal parValue;

    @ApiModelProperty("延期时间")
    private LocalDateTime deadline;











}
