package com.elitesland.sale.api.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.sale.api.vo.param.sal.SalCardParam;
import com.elitesland.sale.api.vo.param.sal.SalReceiveCardParam;
import com.elitesland.sale.api.vo.param.sal.SalReceiveCardSaveParam;
import com.elitesland.sale.api.vo.resp.sal.SalMakeCardRespVO;
import com.elitesland.sale.api.vo.resp.sal.SalReceiveCardDetailVO;
import com.elitesland.sale.api.vo.resp.sal.SalReceiveCardExportVO;
import com.elitesland.sale.api.vo.resp.sal.SalReceiveCardLineRespVO;
import com.elitesland.sale.api.vo.resp.sal.SalReceiveCardRespVO;
import java.util.List;

public interface SalReceiveCardService {

    /**
     * 查询
     * @param salReceiveCardParam
     * @return
     */
    PagingVO<SalReceiveCardRespVO> search(SalReceiveCardParam salReceiveCardParam);

    PagingVO<SalReceiveCardExportVO> export(SalReceiveCardParam salReceiveCardParam);


    /**
     * 保存提交
     * @param salReceiveCardSaveParam
     */
    ApiResult<Object> save(SalReceiveCardSaveParam salReceiveCardSaveParam);

    /**
     * 保存行
     * @param salReceiveCardLineRespVOS
     */
    List<String> saveLine(List<SalReceiveCardLineRespVO> salReceiveCardLineRespVOS);

    /**
     * 详情
     * @param masId
     * @return
     */
    SalReceiveCardRespVO detail(Long masId);


    /**
     * 查询
     * @param salReceiveCardParam
     * @return
     */
    PagingVO<SalReceiveCardLineRespVO> detailLine(SalReceiveCardParam salReceiveCardParam);


    /**
     * 查询
     * @param salReceiveCardParam
     * @return
     */
    List<SalReceiveCardLineRespVO> detailLines(SalReceiveCardParam salReceiveCardParam);


    /**
     * 审核
     * @param salCardParam
     */
    void approve(SalCardParam<SalReceiveCardSaveParam> salCardParam);

    /**
     * 删除
     * @param docIds
     */
    void remove(List<Long> docIds);












}
