package com.elitesland.sale.api.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.sale.api.vo.param.sal.SalCardParam;
import com.elitesland.sale.api.vo.param.sal.SalReceiveCardParam;
import com.elitesland.sale.api.vo.param.sal.SalReturnCardSaveParam;
import com.elitesland.sale.api.vo.param.sal.SalReturnCardParam;

import com.elitesland.sale.api.vo.resp.sal.SalReceiveCardExportVO;
import com.elitesland.sale.api.vo.resp.sal.SalReceiveCardLineRespVO;
import com.elitesland.sale.api.vo.resp.sal.SalReturnCardExportVO;
import com.elitesland.sale.api.vo.resp.sal.SalReturnCardLineVO;
import com.elitesland.sale.api.vo.resp.sal.SalReturnCardVO;
import java.util.List;

public interface SalReturnCardService {

    /**
     * 查询
     * @param salReturnCardParam
     * @return
     */
    PagingVO<SalReturnCardVO> search(SalReturnCardParam salReturnCardParam);

    PagingVO<SalReturnCardExportVO> export(SalReturnCardParam salReturnCardParam);


    /**
     * 保存提交
     * @param salReturnCardSaveParam
     */
    ApiResult<Object> save(SalReturnCardSaveParam salReturnCardSaveParam);

    /**
     * 保存行
     * @param salReturnCardLineVOS
     */
    List<String> saveLine(List<SalReturnCardLineVO> salReturnCardLineVOS);

    /**
     * 详情
     * @param masId
     * @return
     */
    SalReturnCardVO detail(Long masId);


    /**
     * 查询
     * @param salReturnCardParam
     * @return
     */
    PagingVO<SalReturnCardLineVO> detailLine(SalReturnCardParam salReturnCardParam);

    /**
     * 查询
     * @param salReturnCardParam
     * @return
     */
    List<SalReturnCardLineVO> detailLines(SalReturnCardParam salReturnCardParam);


    /**
     * 审核
     * @param salCardParam
     */
    void approve(SalCardParam<SalReturnCardSaveParam> salCardParam);

    /**
     * 删除
     * @param docIds
     */
    void remove(List<Long> docIds);












}
