package com.elitesland.sale.api.vo.param.shop.app;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/24
 */
@Data
@ApiModel(description = "商品列表查询参数")
public class BipItemAppQueryParamVO implements Serializable {
    private static final long serialVersionUID = 2803817296414412124L;

    @ApiModelProperty(value = "公司ID", position = 1)
    private Long ouId;

    @ApiModelProperty(value = "搜索关键字", position = 2)
    private String keyword;

    @ApiModelProperty(value = "页码,默认为1", position = 3)
    private Integer current;

    @ApiModelProperty(value = "页大小,默认为10", position = 4)
    private Integer size;

    @ApiModelProperty(value = "是否按销量排序，true-降序，false-升序", position = 11)
    private Boolean orderSaleDesc;

    @ApiModelProperty(value = "是否按价格排序，true-降序，false-升序", position = 12)
    private Boolean orderPriceDesc;
}
