package com.elitesland.sale.api.vo.param.taskinfo;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-5-19
 * @desc : 销售业绩统计-门店
 */
@Data
@ApiModel(description = "销售业绩统计-门店")
public class SaleStatisticsStoreQueryVO extends AbstractOrderQueryParam {

    /**
     * 统计时间
     */
    @ApiModelProperty("统计开始时间")
    private LocalDateTime docTimeStart;

    @ApiModelProperty("统计结束时间")
    private LocalDateTime docTimeEnd;

    @ApiModelProperty("统计月份(yyyy-MM)-手机端详情使用")
    private String docMonth;

    /**
     * 门店编码
     */
    @ApiModelProperty("门店编码")
    private String storeCode;

    /**
     * 门店名称
     */
    @ApiModelProperty("门店名称")
    private String storeName;

    /**
     * 经销商编码
     */
    @ApiModelProperty("经销商编码")
    private String dealerCode;

    @ApiModelProperty("所属客户编码/名称模糊查询")
    private String dealerKeyword;

    /**
     * 经销商名称
     */
    @ApiModelProperty("经销商名称")
    private String dealerName;

    /**
     * 经销商客户号
     */
    @ApiModelProperty("经销商客户号")
    private String dealerSerialNo;

    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String region;

    /**
     * 类型
     */
    @ApiModelProperty("类型")
    private String type;

    /**
     * 业务员关系路径
     */
    @ApiModelProperty("业务员关系路径")
    private String salesmanPath;

    /**
     * 车型
     */
    @ApiModelProperty("车型")
    private String vehicleType;

    /**
     * 整车类型
     */
    @ApiModelProperty("整车类型")
    private String itemType3;

    /**
     * 出货量
     */
    @ApiModelProperty("出货量")
    private BigDecimal shipQty;

    /**
     * ids
     */
    @ApiModelProperty("ids")
    private List<Long> ids;

    /**
     *业务员名称
     */
    @ApiModelProperty(value = "所属业务员编码")
    private String agentEmp;


    /**
     * 经营性质
     */
    @ApiModelProperty(value = "经营性质")
    private String storeType2;

    /**
     * 门店详细地址
     */
    @ApiModelProperty(value = "门店详细地址")
    private String detailAddr;

}