package com.elitesland.sale.api.vo.resp.sal;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.sale.api.vo.resp.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDateTime;
import javax.validation.constraints.NotNull;
import lombok.Data;

@Data
@ApiModel(description = "卡券申领单展示")
public class SalReturnCardVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = 7971853965370958839L;

    @ApiModelProperty("单据编码")
    private String docNo;

    @ApiModelProperty("单据状态 [UDC]SAL:CARD_DOC_STATUS")
    @SysCode(sys = "yst-sale", mod = "CARD_DOC_STATUS")
    private String docStatus;

    @ApiModelProperty("单据状态 [UDC]SAL:CARD_DOC_STATUS")
    private String docStatusName;


    @ApiModelProperty("公司Id")
    @NotNull(message = "公司不能为空")
    private Long ouId;

    @ApiModelProperty("公司code")
    private String ouCode;

    @ApiModelProperty("公司name")
    private String ouName;

    @ApiModelProperty("仓库Id")
    @NotNull(message = "领用仓库不能为空")
    private Long whId;

    @ApiModelProperty("仓库code")
    private String whCode;

    @ApiModelProperty("仓库name")
    private String whName;

    @ApiModelProperty("业务员ID")
    @NotNull(message = "业务员不能为空")
    private Long agentEmpId;

    @ApiModelProperty("业务员Code")
    private String agentEmpCode;

    @ApiModelProperty("业务员Name")
    private String agentEmpName;

    @ApiModelProperty("退卡数量")
    private Integer cardCount;

    @ApiModelProperty("审核人")
    private Long approvedUserId;

    @ApiModelProperty("审核人")
    private String approvedUserName;

    @ApiModelProperty("审核时间")
    private LocalDateTime approvedTime;




}
