package com.elitesland.sale.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.sale.Application;
import com.elitesland.sale.api.vo.param.crm.CrmCustQueryLmParam;
import com.elitesland.sale.api.vo.param.crm.CrmCustQueryParam;
import com.elitesland.sale.api.vo.param.crm.CustCode2BaseParam;
import com.elitesland.sale.api.vo.resp.crm.*;
import com.elitesland.sale.api.vo.resp.sal.RmiOrgBankAccRpcVO;
import com.elitesland.sale.dto.*;
import com.elitesland.sale.dto.param.CrmCust2BaseParam;
import com.elitesland.sale.dto.param.CustBaseRpcParam;
import com.elitesland.sale.dto.save.CrmCustRpcSaveDto;
import com.elitesland.sale.dto.param.CrmCustRpcDtoParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import feign.Param;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

/**
 * 客户中心服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2021-05-14
 */
@FeignClient(name = Application.NAME, path = CrmCustRpcService.URI)
public interface CrmCustRpcService {
    String URI = Application.URI_PREFIX + "/cust";





    /**
     * 立马 客户保存
     * @param save
     * @return
     */
    @PostMapping("/saveLmCust")
    ApiResult<LmSaveCustRespVO> saveCustLm(@RequestBody LmCrmCustSaveVO save);


    @PostMapping("/getByCustBase")
    ApiResult<List<CustCode2BaseDTO>> getByCust2Base(@RequestBody CustCode2BaseParam save);

    /**
     * 立马 分页查询客户
     * @param param
     * @return
     */
    @PostMapping("/queryPage")
    PagingVO<CrmCustPageLmVO> pageLm(@RequestBody CrmCustQueryLmParam param);


    @PostMapping("/searchExport")
    List<CrmCustPageLmVO> searchExport(@RequestBody CrmCustQueryParam param);


    /**
     *
     * @param custCode
     * @return
     */
    @GetMapping("/findInvCust")
    ApiResult<List<LmSaveCustRespVO>> findInvCust(@RequestParam("custCode") List<String> custCode);


    @PostMapping("/findBaseCustInfo")
    List<LmSaveCustRespVO> findBaseCustInfo(@RequestBody CustCode2BaseParam param);



    /**
     * 根据客户ID获取客户名称
     *
     * @param id 客户ID
     * @return 客户名称
     */
	@GetMapping("/crmCustRpc/getCustName")
    ApiResult<String> getCustName(@Param("id") Long id);

    /**
     * 根据客户ID查询客户信息
     *
     * @param ids 客户ID
     * @return 客户信息
     */
	@PostMapping("/crmCustRpc/listCustById")
    ApiResult<List<CrmCustDTO>> listCustById(@RequestBody List<Long> ids);

    /**
     * 搜索客户信息
     *
     * @param keyword 关键字（客户名称、编码）
     * @return 客户信息
     */
	@GetMapping("/crmCustRpc/query")
    ApiResult<List<CrmCustSimpleDTO>> query(@Param("keyword") String keyword);

    /**
     * 根据业务员ID获取关联的客户数据
     *
     * @param agentEmpId 数据id
     * @return 客户数据集合
     */
	@GetMapping("/crmCustRpc/queryAllByAgentEmpId")
    ApiResult<List<CrmCustRespDTO>> queryAllByAgentEmpId(@Param("agentEmpId") Long agentEmpId);

    /**
     * 根据业务员ID获取关联的下级业务员关联的客户
     *
     * @param agentEmpId 数据id
     * @return 客户数据集合
     */
    @GetMapping("/crmCustRpc/queryAllByAgentEmpIdAndSub")
    public ApiResult<List<CrmCustBaseRespVO>> queryAllByAgentEmpIdAndSub(@RequestParam("agentEmpId") Long agentEmpId);

    /**
     * 根据登陆用户查询客户信息
     * @param userName
     * @return
     */
    @GetMapping("/crmCustRpc/getCustByUserName")
	List<CrmCustSimpleDTO> getCustByUserName(@RequestParam("userName") String userName);


    /**
     * 根据登陆用户查询客户信息
     * @param custCode
     * @return
     */
    @GetMapping("/crmCustRpc/getCustInfo")
    ApiResult<CrmCustDTO> getCustInfo(@RequestParam("custCode") String custCode);


    /**
     * 根据客户id获取关联的客户数据
     *
     * @param id 客户id
     * @return 客户数据集合
     */
	@GetMapping("/crmCustRpc/getCreditLimitById")
    ApiResult<BigDecimal> getCreditLimitById(@Param("id") Long id);

    /**
     * 根据客户id获取客户状态
     *
     * @param id 客户id
     * @return 客户状态
     */
	@GetMapping("/crmCustRpc/getStatusById")
    ApiResult<String> getStatusById(@Param("id") Long id);


    @PostMapping("/crmCustRpc/getBaseCustByCodes")
    ApiResult<List<CrmCustBaseDTO>> getBaseCustByParam(@RequestBody List<String> custCodes);
    @PostMapping("/crmCustRpc/getBaseCustByNames")
    ApiResult<List<CrmCustBaseDTO>> getCustBase(@RequestBody CustBaseRpcParam param);


    /**
     * 根据条件获取客户信息
     *
     * @param crmCustRpcDtoParam 客户查询参数
     * @return 客户信息
     */
	@PostMapping("/crmCustRpc/getCustByParam")
    ApiResult<List<CrmCustRespDTO>> getCustByParam(@RequestBody CrmCustRpcDtoParam crmCustRpcDtoParam);


    /**
     * 保存数据
     *
     * @param saveDto 数据对象
     * @return 数据ID
     */
	@PostMapping("/crmCustRpc/save")
    ApiResult<Long> save(CrmCustRpcSaveDto saveDto);

//    /**
//     *
//     * 查询主数据的所有ERP编码
//     * @return
//     */
//    ApiResult<List<String>> getAllErpCode();

    /**
     *
     * 判断员工和客户是否有从属关系
     * @return
     */
	@PostMapping("/crmCustRpc/judgeDependEmpAndCust")
    ApiResult<Object> judgeDependEmpAndCust(@RequestBody List<CrmCustJudgeDTO> crmCustJudgeDTOS);

    @PostMapping("/getCustBaseInfoByCode")
    ApiResult<List<CustBaseInfoDTO>> getCustBaseInfoByCode(@RequestBody CustCode2BaseParam crmCust2BaseParam);


    /**
     * 查询业务员信息批量
     */
    @PostMapping("/queryLevelInfos")
    ApiResult<List<SalesmanLevelInfoDTO>> queryLevelInfos(@RequestParam("ids") List<Long> ids);

    @GetMapping("/getCustSimple")
    CrmCustSimpleVO getCustSimple(@RequestParam("userName") String userName);
    @GetMapping("/findBankAccRpcDtoByCustCode")
    List<RmiOrgBankAccRpcVO> findBankAccRpcDtoByCustCode(@RequestParam("custCode") String custCode);



}
