package com.elitesland.sale.api.vo.param.crm;

import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Data
@Builder
public class AllowShipSaleParam implements Serializable {
    private static final long serialVersionUID = 7053865286550728949L;

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("名称组编码")
    private String custGroupCode;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("商品组编码")
    private String itemGroupCode;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("规则编码")
    private String ruleCode;

    private LocalDate validTime;

    @ApiModelProperty("生效时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate validFromTime;

    @ApiModelProperty("失效时间")
    private LocalDate validToTime;
}
