package com.elitesland.sale.api.vo.resp.salesman;

import com.elitescloud.cloudt.common.base.vo.AreaVO;
import com.elitesland.sale.api.vo.param.salesman.SalesmanRegionVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author Danny.Wang
 * @title SalesmanInfoSimpleRespVO
 * @Date2023/5/30 14:01
 */
@Data
@ApiModel("业务员基本信息查询返回参数")
public class SalesmanInfoSimpleRespVO implements Serializable {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("业务员编号")
    private String salesmanNo;

    @ApiModelProperty("姓名")
    private String fullName;

    @ApiModelProperty("是否启用")
    private Integer enableStatus;

    @ApiModelProperty("省市区")
    private AreaVO areaVO;

    @ApiModelProperty("详细地址")
    private String address;

    @ApiModelProperty("办公电话、手机号")
    private String phone;

    @ApiModelProperty("管辖区域")
    private List<SalesmanRegionVO> jurisdiction;

    @ApiModelProperty("业务员类型")
    private String salesmanType;

    @ApiModelProperty("业务员类型名称")
    private String salesmanTypeName;


}
